/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropDead;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.objects.te.TECropBase;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        IBlockState state = world.func_180495_p(pos);
        TECropBase te = Helpers.getTE((IBlockAccess)world, pos, TECropBase.class);
        if (state.func_177230_c() instanceof BlockCropTFC && te != null) {
            BlockCropTFC bs = (BlockCropTFC)state.func_177230_c();
            ICrop crop = bs.getCrop();
            boolean isWild = (Boolean)state.func_177229_b((IProperty)BlockCropTFC.WILD);
            float temp = ClimateTFC.getActualTemp(world, pos, -te.getLastUpdateTick());
            float rainfall = ChunkDataTFC.getRainfall(world, pos);
            if (isWild) {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.wild", new Object[0]).func_150254_d());
            } else if (crop.isValidForGrowth(temp, rainfall)) {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growing", new Object[0]).func_150254_d());
            } else {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.not_growing", new Object[0]).func_150254_d());
            }
            int curStage = (Integer)state.func_177229_b((IProperty)bs.getStageProperty());
            int maxStage = crop.getMaxStage();
            if (curStage == maxStage) {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growth", new Object[]{new TextComponentTranslation("waila.tfc.crop.mature", new Object[0]).func_150254_d()}).func_150254_d());
            } else {
                float remainingTicksToGrow = Math.max(0.0f, (float)crop.getGrowthTicks() * (float)ConfigTFC.General.FOOD.cropGrowthTimeModifier - (float)te.getTicksSinceUpdate());
                float curStagePerc = 1.0f - remainingTicksToGrow / (float)crop.getGrowthTicks();
                float totalPerc = Math.min(0.99f, curStagePerc / (float)maxStage + (float)curStage / (float)maxStage) * 100.0f;
                String growth = String.format("%d%%", Math.round(totalPerc));
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growth", new Object[]{growth}).func_150254_d());
            }
        } else if (state.func_177230_c() instanceof BlockCropDead) {
            currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.dead_crop", new Object[0]).func_150254_d());
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public String getTitle(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCropTFC) {
            BlockCropTFC b = (BlockCropTFC)state.func_177230_c();
            return new TextComponentTranslation(b.func_149739_a() + ".name", new Object[0]).func_150254_d();
        }
        if (state.func_177230_c() instanceof BlockCropDead) {
            BlockCropDead b = (BlockCropDead)state.func_177230_c();
            ICrop crop = b.getCrop();
            return new TextComponentTranslation("tile.tfc.crop." + crop.toString().toLowerCase() + ".name", new Object[0]).func_150254_d();
        }
        return "";
    }

    @Override
    @Nonnull
    public ItemStack getIcon(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCropTFC) {
            BlockCropTFC b = (BlockCropTFC)state.func_177230_c();
            ICrop crop = b.getCrop();
            return crop.getFoodDrop((Integer)state.func_177229_b((IProperty)b.getStageProperty()));
        }
        if (state.func_177230_c() instanceof BlockCropDead) {
            BlockCropDead b = (BlockCropDead)state.func_177230_c();
            ICrop crop = b.getCrop();
            return new ItemStack((Item)ItemSeedsTFC.get(crop));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return ImmutableList.of(BlockCropTFC.class, BlockCropDead.class);
    }

    @Override
    public boolean overrideTitle() {
        return true;
    }

    @Override
    public boolean overrideIcon() {
        return true;
    }
}

